<?php

namespace App\Question;

use Illuminate\Database\Eloquent\Model;

class Question extends Model 
{

    protected $table = 'Question';
    public $timestamps = true;

    public function testType()
    {
        return $this->belongsTo('TestType', 'id');
    }

    public function choices()
    {
        return $this->hasMany('QuestionChoice', 'id');
    }

    public function difficulty()
    {
        return $this->hasOne('QuestionDifficulty', 'id');
    }

}